#!/bin/sh
. ./master_page_ms_dhcp_or_static.sh
. ./master_page_ms_network_conf.sh
. ./master_page_esxi_info_conf.sh
. ./master_page_sc_dhcp_or_static.sh
. ./master_page_sc_network_conf.sh
. ./master_page_sb_internet_conn.sh
. ./master_page_nat_dhcp_or_static.sh
. ./master_page_nat_network_conf.sh

reconfig_network() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    # need to set RT_DEPLOY_STATUS to 0 or TUI would sync MS IP to SC after MS IP setting
    RT_DEPLOY_STATUS=0
    
    reconfig_network_pages_array="
        master_page_ms_dhcp_or_static
        master_page_ms_network_conf
        master_page_esxi_info_conf
        master_page_sc_dhcp_or_static
        master_page_sc_network_conf
        master_page_sb_internet_conn
        master_page_nat_dhcp_or_static
        master_page_nat_network_conf
        "
    pages_roller "${reconfig_network_pages_array}"
    
    RT_DEPLOY_STATUS=1
    
    # sync MS IP to SC
    local sync_ret
    sync_ret=`php "${CONS_BACKEND}" sync_server_ip_to_controller "${RT_MS_IP:-$conf_ms_ip}" 0`
    if [ "${?}" -ne 0 ]; then
        debug_print "fail to sync_server_ip_to_controller: ${sync_ret}"
        warning "${AFTER_NETWORK_RECONFIG_FAIL_TO_SYNC_IP}" "${sync_ret}"        
        return 1
    fi
}

auto_detect_network_change() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    # try to login esxi server
    local taskName="DetectNetworkChange"
    debug_print "${taskName}"
    
    local stepName="LoginEsxiServer"
    local unable_connect_to_esxi=0
    debug_print "${stepName}: ip='${conf_esxi_ip}', user='${conf_esxi_username}'"
    php "${CONS_BACKEND}" list_all_esxi_vms_by_vix \
        "${conf_esxi_ip}" \
        "${conf_esxi_username}" \
        "${conf_esxi_password}" \
        1>/dev/null 2>&1
    
    if [ "${?}" -ne 0 ]; then
        debug_print "${stepName}Fail"
        unable_connect_to_esxi=1
    fi
    
    # get current management server ip from eth0
    local current_ms_ip=`ifconfig eth0 | sed -n 's/.*inet *addr:\\([0-9\\.]*\\).*/\\1/p'`

    debug_print "current_ms_ip='$current_ms_ip', conf_ms_ip='${conf_ms_ip}'"
    if [ "${conf_ms_ip}" != "${current_ms_ip}" ] || [ "${unable_connect_to_esxi}" -eq 1 ]; then
        tp_yesno "${ASK_RECONFIG_NETWORK_TITLE}" "${ASK_RECONFIG_NETWORK_MSG}"
        if [ "${TP_YESNO_RESULT_SELECT}" == "${TP_YESNO_RESULT_YES}" ]; then
            reconfig_network
        fi
    fi
}